# Changelog

All notable changes to Queschan are documented here.

## [3.0] - 2025-11-06

### Added
- `setup.php` installation wizard for first-time configuration
- Dynamic `data/config.json` replaces all hardcoded site settings
- Admin Panel 2.0 with tabbed interface: General Settings, Theme, About Page, Channels
- Live color picker in Theme tab for full UI customization without editing CSS
- Configurable privacy modes: **Hashed IDs** (HMAC-SHA256 tripcodes) or **Anonymous**
- `about.php` with admin-editable content, replacing the static `about.html`

### Changed
- Refactored `index.php` core logic, reducing file size by ~45% while adding new functionality
- Administrator authentication migrated to PHP `password_hash()` / `password_verify()`

## [2.12] - 2025-05-10

### Added
- `rss.php` generating RSS 2.0 feeds per channel (fixes 404 errors on RSS links)

### Fixed
- Restored search functionality (form and results display) that had been temporarily removed

## [2.11] - 2025-05-05

### Changed
- Channel listing on homepage now sorts by latest activity first (most recent post or comment), then alphabetically

## [2.10] - 2025-05-04

### Fixed
- `ip_to_alpha` function no longer raises "Undefined array key" errors; added strict IP validation via `filter_var` and bounds checking for character indices
- Improved error logging for invalid IP addresses and index issues

## [2.9] - 2025-05-03

### Added
- Client-side timestamp localization using `<span data-timestamp>` elements, displaying times in the visitor's local timezone

### Changed
- Extracted all inline CSS from `index.php` into a separate `styles.css` file

### Fixed
- Updated color scheme to meet WCAG 2.1 Level AA contrast ratios (4.5:1 for normal text, 3:1 for large text and UI components)

## [2.8] - 2025-04-30

### Added
- View count tracking per channel, showing total views and unique visitor counts

### Changed
- Comment nesting capped at 3 levels to improve readability

## [2.7] - 2025-04-25

### Added
- ASCII art conversion for image uploads to deter illicit content while preserving visual context
- Open Graph meta tags for improved social media link previews on posts and comments
