# Queschan

A lightweight, file-based anonymous discussion platform. No database required — everything is stored as JSON files. Built with PHP 8.2.

> *"Q is to Question"*

## Features

- **Channel-based boards** — Create and manage topic channels, each with its own post feed
- **Threaded comments** — Nested replies up to 3 levels deep
- **Privacy modes** — Choose between hashed tripcodes (HMAC-SHA256) or fully anonymous posting
- **ASCII art images** — Uploaded images are converted to ASCII art to deter illicit content
- **Rate limiting** — 5 posts per minute, 50 posts per day per IP
- **Math CAPTCHA** — Simple addition challenge to block automated submissions
- **Admin panel** — Tabbed control panel for settings, theming, content, and channel management
- **Dynamic theming** — Full color scheme customization via live color pickers, no CSS editing needed
- **Channel view tracking** — Total and unique visitor counts per channel
- **Search** — Full-text search across all channels and comments
- **RSS feeds** — Per-channel RSS 2.0 feeds via `rss.php`
- **Open Graph tags** — Rich previews when sharing posts on social media
- **Localized timestamps** — Post times rendered in the visitor's local timezone via JavaScript

## Requirements

- PHP 8.2 or higher
- PHP extensions: `gd`, `json`, `mbstring`
- Web server (Apache or Nginx) with PHP support
- Write permissions on the server for `data/`, `posts/`, and `images/` directories

## Installation

1. Upload all files to your web server.
2. Ensure the web server can write to the project root (for auto-created directories).
3. Open `setup.php` in your browser.
4. Fill in your site name, slogan, privacy mode, and admin password.
5. Click **Install**.
6. **Delete `setup.php`** from the server after setup is complete.
7. Navigate to `index.php` to start using your site.

## Directory Structure

```
/
├── index.php          # Main application (home, channels, posts, admin panel)
├── about.php          # Dynamic about page (content editable from admin panel)
├── setup.php          # One-time installation wizard (delete after use)
├── changelog.html     # Version history
├── styles.css         # Stylesheet
├── data/
│   ├── config.json    # Site configuration (name, theme, admin hash, privacy mode)
│   ├── channels.json  # Channel definitions
│   ├── about.json     # About page content
│   ├── rate_*.json    # Per-IP rate limit records
│   └── views_*.json   # Per-channel view counts
├── posts/
│   └── <channel>.json # Posts and nested comments for each channel
└── images/
    └── ascii_*.png    # ASCII-art converted images
```

## Admin Panel

Log in via the hidden **Admin** toggle at the bottom of any page. The panel includes four tabs:

| Tab | Description |
|---|---|
| **General** | Site name, slogan, homepage description, privacy mode, admin password |
| **Theme** | Live color pickers for all UI variables |
| **About Page** | Edit the title and HTML content of the About page |
| **Channels** | Create new channels or delete existing ones |

## Privacy & Security

- IP addresses are never stored in plaintext. Poster IDs are derived using HMAC-SHA256 with a randomly generated per-install secret.
- In **Anonymous** mode, no ID is displayed at all.
- Admin passwords are stored using PHP's `password_hash()` (bcrypt).
- All user-supplied content is escaped with `htmlspecialchars()` before output.
- File writes use exclusive locks (`flock`) to prevent race conditions.
- Error logging rotates automatically at 5 MB.

## Limits & Constants

| Setting | Value |
|---|---|
| Max post length | 4096 characters |
| Posts per minute | 5 |
| Posts per day | 50 |
| Max comment depth | 3 levels |
| Log rotation size | 5 MB |

## License

Copyright 2025 The Brown Hats Collectives.
