<?php
declare(strict_types=1);
const DATA_DIR = 'data/';
const CONFIG_FILE = DATA_DIR . 'config.json';
$config = file_exists(CONFIG_FILE) ? json_decode(file_get_contents(CONFIG_FILE), true) : ['site_name'=>'Queschan','theme'=>[]];

$about_file = DATA_DIR . 'about.json';
$about = file_exists($about_file) 
    ? json_decode(file_get_contents($about_file), true) 
    : ['title' => 'About', 'content' => '<p>Content not yet configured.</p>'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($about['title']); ?> - <?php echo $config['site_name']; ?></title>
    <link rel="stylesheet" href="styles.css">
    <style>
         /* Apply dynamic theme to about page too */
        :root {
            <?php foreach(($config['theme'] ?? []) as $k => $v) { echo "--".str_replace('_','-',$k).": $v;"; } ?>
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="nav">
            <a href="index.php">Home</a>
            <a href="about.php">About</a>
        </div>
        <h1><?php echo htmlspecialchars($about['title']); ?></h1>
        <div class="content-body">
            <?php echo $about['content']; ?>
        </div>
        <div class="footer">
            <p><?php echo $config['site_name']; ?> Platform</p>
        </div>
    </div>
</body>
</html>
